class Karte(
    farbe: String,   // "Herz", "Karo", "Pik", "Kreuz" (ausgeschrieben, Groß/Kleinschreibung egal)
    rang: String     // "2"–"10", "B"/"Bube", "D"/"Dame", "K"/"Koenig", "A"/"Ass"
    ) {

    val rang: String = kuerzeRang(rang)
    val farbe: String = normalisiereFarbe(farbe)

    fun berechneWert(): Int {
        return when (rang) {
            "A" -> 11
            "B", "D", "K" -> 10
            else -> rang.toInt()
        }
    }

    fun druckeKarte() {
        val symbol = when (farbe) {
            "herz" -> "♥"
            "karo" -> "♦"
            "pik" -> "♠"
            "kreuz" -> "♣"
            else -> "?"
        }

        val right = rang.padStart(2, ' ')
        val left = rang.padEnd(2, ' ')

        println("┌─────┐")
        println("│$left   │")
        println("│  $symbol  │")
        println("│   $right│")
        println("└─────┘")
    }

    private fun kuerzeRang(roherRang: String): String {
        val normalisiert = roherRang.trim().lowercase()
        return when (normalisiert) {
            "a", "ass" -> "A"
            "k", "koenig", "könig" -> "K"
            "d", "dame" -> "D"
            "b", "bube" -> "B"
            else -> {
                val zahl = normalisiert.toIntOrNull()
                    ?: throw IllegalArgumentException("Unbekannter Rang: $roherRang")
                if (zahl in 2..10) zahl.toString()
                else throw IllegalArgumentException("Rang ausserhalb des Bereichs: $roherRang")
            }
        }
    }

    private fun normalisiereFarbe(roheFarbe: String): String {
        return when (val normalisiert = roheFarbe.trim().lowercase()) {
            "herz", "karo", "pik", "kreuz" -> normalisiert
            else -> throw IllegalArgumentException("Unbekannte Farbe: $roheFarbe")
        }
    }
}
