class Stapel {

    private val karten: MutableList<Karte> = mutableListOf()
   
    fun zaehleKarten(): Int = karten.size
   
    fun erzeugeBlaetter(anzahlBlaetter: Int) {
        val raenge = listOf(
            "2", "3", "4", "5", "6", "7", "8", "9", "10",
            "B", "D", "K", "A"
        )
        val farben = listOf("Herz", "Karo", "Pik", "Kreuz")

        repeat(anzahlBlaetter) {
            for (farbe in farben) {
                for (rang in raenge) {
                    karten.add(Karte(farbe, rang))
                }
            }
        }
    }

    fun mischen() = karten.shuffle()

    private fun zieheKarte(): Karte? {
        if (karten.isEmpty())
            return null
        else
            return karten.removeAt(0)
    }
    
    fun zieheUndZeige() {
        if (karten.isEmpty()) {
            println("Es ist keine Karte mehr übrig")
        }
        else {
            zeigeObersteKarte()
            zieheKarte()
        }
    }

    fun zeigeObersteKarte() {
        if (karten.isEmpty()) 
            println("Stapel ist leer")
        else
            karten.first().druckeKarte()
    }

    fun druckeAlle() {
        for (karte in karten) {
            karte.druckeKarte()
        }
    }
}
